/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSTModel;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.business.Contact;

public final class VWUDDIExplorerPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
IVWToolbarBorderActionListener,
ItemSelectable,
DocumentListener,
MouseListener {
    Window m_parent = null;
    VWSession m_session = null;
    boolean m_bInitialized = false;
    boolean m_bFirstTime = true;
    private UDDIRegistry[] m_uddiRegistryList = null;
    private UDDIRegistryList m_uddiRegistrListObject = new UDDIRegistryList();
    private JSplitPane m_mainPanel = null;
    private JScrollPane m_treeScrollPane = null;
    private JPanel m_blankPanel = new JPanel();
    private JScrollPane m_uddiRegistryPane = null;
    private JPanel m_uddiRegistryPanel = null;
    private JPanel m_businessQueryPanel = null;
    private JScrollPane m_businessDetailsPane = null;
    private JPanel m_businessDetailsPanel = null;
    private JScrollPane m_tModelDetailsPane = null;
    private JPanel m_tModelDetailsPanel = null;
    private JPanel m_tModelQueryPanel = null;
    private JTextField m_uddiRegistryNameUI = null;
    private JTextArea m_inquiryURLUI = null;
    private JTextArea m_publishURLUI = null;
    private JTextField m_businessQueryNameUI = null;
    private JCheckBox m_businessQueryCaseSensitiveUI = null;
    private JCheckBox m_businessQueryExactMatchUI = null;
    private JButton m_businessQueryExecuteBtn = null;
    private BusinessQuery m_lastBusinessQueryObject = null;
    private boolean m_bBusinessQueryCaseSensitive = false;
    private boolean m_bBusinessQueryExactMatch = false;
    private JTextField m_bussinessNameUI = null;
    private JTextField m_bussinessAuthorizedNameUI = null;
    private JTextField m_bussinessKeyUI = null;
    private JTextField m_discoveryURLUseTypeUI = null;
    private JTextArea m_discoveryURLUI = null;
    private ContactToolbarBorder m_contactToolbarBorder = null;
    private JTextArea m_contactDescriptionUI = null;
    private JTextField m_contactUseTypeUI = null;
    private JTextField m_contactNameUI = null;
    private JPanel m_contactAddressPanel = null;
    private JTextField[] m_contactAddressUI = null;
    private JPanel m_contactPhonePanel = null;
    private JTextField[] m_contactPhoneUI = null;
    private JPanel m_contactEmailPanel = null;
    private JTextField[] m_contactEmailUI = null;
    private Vector m_contacts = null;
    private int m_currentContact = -1;
    private JTextField m_tModelNameUI = null;
    private JTextField m_tModelAuthorizedName = null;
    private JTextArea m_tModelDescriptionUI = null;
    private JTextField m_tModelKeyUI = null;
    private JTextArea m_tModelOverviewDocDescriptionUI = null;
    private JTextArea m_tModelOverviewDocURLUI = null;
    private JTextField m_tModelQueryNameUI = null;
    private JCheckBox m_tModelQueryCaseSensitiveUI = null;
    private JCheckBox m_tModelQueryExactMatchUI = null;
    private JButton m_tModelQueryExecuteBtn = null;
    private TModelQuery m_lastTModelQueryObject = null;
    private boolean m_bTModelQueryCaseSensitive = false;
    private boolean m_bTModelQueryExactMatch = false;
    private WSTModel m_lastSelectedTModel = null;
    private WSTModel m_currentSelectedTModel = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private JTree m_tree = null;
    private DefaultTreeModel m_treeModel = null;
    private DefaultMutableTreeNode[] m_registryTreeNodes = null;
    private boolean m_bTreeInitialized = false;
    private boolean m_bHasFocus = false;
    private JPopupMenu m_popup = null;
    private JMenuItem m_refreshMenuItem = null;
    private DefaultMutableTreeNode m_popupTreeNode = null;
    private Object m_popupUserObject = null;
    protected ItemListener m_selectListeners = null;
    private ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());

    public VWUDDIExplorerPanel(Frame parent, VWSession session) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.m_session = session;
        this.initData(new VWUDDIRegistryList(this.m_session));
        this.setupLayout();
    }

    public VWUDDIExplorerPanel(Frame parent, VWUDDIRegistryList vwRegistryList) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.initData(vwRegistryList);
        this.setupLayout();
    }

    public VWUDDIExplorerPanel(Dialog parent, VWSession session) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.m_session = session;
        this.initData(new VWUDDIRegistryList(this.m_session));
        this.setupLayout();
    }

    public VWUDDIExplorerPanel(Dialog parent, VWUDDIRegistryList vwRegistryList) {
        super(new BorderLayout(10, 10));
        this.m_parent = parent;
        this.initData(vwRegistryList);
        this.setupLayout();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(0.5);
            }
        }
    }

    protected void initData(VWUDDIRegistryList vwRegistryList) {
        this.m_bInitialized = true;
        if (vwRegistryList != null) {
            VWUDDIRegistry[] vwUDDIRegistries = vwRegistryList.getUDDIRegistries();
            if (vwUDDIRegistries != null && vwUDDIRegistries.length > 0) {
                this.m_uddiRegistryList = new UDDIRegistry[vwUDDIRegistries.length];
                for (int i = 0; i < vwUDDIRegistries.length; ++i) {
                    if (vwUDDIRegistries[i] == null) continue;
                    this.m_uddiRegistryList[i] = new UDDIRegistry(vwUDDIRegistries[i]);
                }
            }
        } else {
            this.m_uddiRegistryList = new UDDIRegistry[2];
            this.m_uddiRegistryList[0] = new UDDIRegistry("XMethods", "http://services.xmethods.net:80/glue/inquire/uddi", null, false);
            this.m_uddiRegistryList[1] = new UDDIRegistry("IBM", "http://www-3.ibm.com/services/uddi/inquiryapi", "https://www-3.ibm.com/services/uddi/protect/publishapi", false);
        }
        if (this.m_uddiRegistryList == null) {
            this.m_uddiRegistryList = new UDDIRegistry[0];
        }
        this.m_registryTreeNodes = null;
        if (this.m_rootNode == null) {
            this.m_rootNode = new DefaultMutableTreeNode(this.m_uddiRegistrListObject);
        } else {
            this.m_rootNode.removeAllChildren();
        }
        Vector<DefaultMutableTreeNode> registryNodes = new Vector<DefaultMutableTreeNode>();
        if (this.m_uddiRegistryList != null && this.m_uddiRegistryList.length > 0 && this.m_uddiRegistryList[0] != null) {
            Object uddiRegistry = null;
            DefaultMutableTreeNode registryNode = null;
            DefaultMutableTreeNode businessListNode = null;
            Object businessNode = null;
            Object tModelNode = null;
            DefaultMutableTreeNode tModelListNode = null;
            for (int i = 0; i < this.m_uddiRegistryList.length; ++i) {
                if (this.m_uddiRegistryList[i] == null) continue;
                registryNode = new DefaultMutableTreeNode(this.m_uddiRegistryList[i]);
                this.m_rootNode.add(registryNode);
                businessListNode = new DefaultMutableTreeNode(new BusinessQuery(this.m_uddiRegistryList[i]));
                businessListNode.setAllowsChildren(true);
                registryNode.add(businessListNode);
                tModelListNode = new DefaultMutableTreeNode(new TModelQuery(this.m_uddiRegistryList[i]));
                tModelListNode.setAllowsChildren(true);
                registryNode.add(tModelListNode);
                registryNodes.add(registryNode);
            }
            if (registryNodes != null && registryNodes.size() > 0) {
                this.m_registryTreeNodes = new DefaultMutableTreeNode[registryNodes.size()];
                registryNodes.toArray(this.m_registryTreeNodes);
            }
        }
    }

    void refresh() {
        if (this.m_session == null) {
            return;
        }
        VWUDDIRegistryList vwRegistryList = new VWUDDIRegistryList(this.m_session);
        this.initData(vwRegistryList);
        this.m_treeModel.nodeStructureChanged(this.m_rootNode);
    }

    protected void setupLayout() {
        this.setVisible(false);
        this.m_mainPanel = new JSplitPane(1, false);
        this.m_treeScrollPane = this.initTreePanel();
        if (this.compOrientation.isLeftToRight()) {
            this.m_mainPanel.setLeftComponent(this.m_treeScrollPane);
            this.m_mainPanel.setRightComponent(this.m_blankPanel);
        } else {
            this.m_mainPanel.setLeftComponent(this.m_blankPanel);
            this.m_mainPanel.setRightComponent(this.m_treeScrollPane);
        }
        this.m_mainPanel.applyComponentOrientation(this.compOrientation);
        this.add((Component)this.m_mainPanel, "Center");
    }

    private void initUDDIRegistryPanel() {
        if (this.m_uddiRegistryPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_uddiRegistryPanel = new JPanel();
        this.m_uddiRegistryPane = new JScrollPane(this.m_uddiRegistryPanel);
        this.m_uddiRegistryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_uddiBusinessRegistryDetails, 0);
        this.m_uddiRegistryPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_uddiRegistryNameUI = new JTextField();
        this.m_uddiRegistryNameUI.setEditable(false);
        this.m_uddiRegistryNameUI.setBorder(null);
        JLabel inquiryURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_inquiryURL));
        this.m_inquiryURLUI = new JTextArea();
        this.m_inquiryURLUI.setEditable(false);
        this.m_inquiryURLUI.setRows(1);
        this.m_inquiryURLUI.setColumns(20);
        this.m_inquiryURLUI.setLineWrap(true);
        this.m_inquiryURLUI.setWrapStyleWord(true);
        this.m_inquiryURLUI.setBackground(panel.getBackground());
        JLabel publishURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_publishURL));
        this.m_publishURLUI = new JTextArea();
        this.m_publishURLUI.setEditable(false);
        this.m_inquiryURLUI.setRows(1);
        this.m_publishURLUI.setColumns(20);
        this.m_publishURLUI.setLineWrap(true);
        this.m_publishURLUI.setWrapStyleWord(true);
        this.m_publishURLUI.setBackground(panel.getBackground());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_uddiRegistryNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)inquiryURLLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_inquiryURLUI), c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)publishURLLabel, c);
        c.gridy = 5;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_publishURLUI), c);
    }

    private void showPopup(MouseEvent event) {
        TreePath path;
        Object obj;
        Object source = event.getSource();
        Point point = event.getPoint();
        if (source == this.m_tree && (obj = (path = this.m_tree.getPathForLocation(point.x, point.y)).getLastPathComponent()) != null && obj instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)obj).getUserObject();
            this.m_popupTreeNode = (DefaultMutableTreeNode)obj;
            this.m_popupUserObject = userObject;
            this.createPopup(this.m_tree, event);
        }
    }

    public void createPopup(Container container, MouseEvent evt) {
        Object source = evt.getSource();
        Point point = evt.getPoint();
        if (this.m_popup == null) {
            this.m_popup = new JPopupMenu();
            if (this.m_refreshMenuItem == null) {
                this.m_refreshMenuItem = new JMenuItem(VWResource.s_refresh);
                this.m_refreshMenuItem.addActionListener(this);
            }
            this.m_popup.add(this.m_refreshMenuItem);
        }
        this.m_popup.show(container, point.x, point.y);
    }

    private void updateUDDIRegistryPanel(UDDIRegistry uddiRegistry) {
        this.initUDDIRegistryPanel();
        if (this.m_uddiRegistryPane == null || uddiRegistry == null) {
            return;
        }
        if (this.m_uddiRegistryNameUI != null) {
            this.m_uddiRegistryNameUI.setText(uddiRegistry.getName());
        }
        if (this.m_inquiryURLUI != null) {
            this.m_inquiryURLUI.setText(uddiRegistry.getInquiryURL());
        }
        if (this.m_publishURLUI != null) {
            this.m_publishURLUI.setText(uddiRegistry.getPublishURL());
        }
    }

    private void initBusinessQueryPanel() {
        if (this.m_businessQueryPanel != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_businessQueryPanel = new JPanel();
        this.m_businessQueryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_uddiBusinessQuery, 0);
        this.m_businessQueryPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_businessQueryNameUI = new JTextField();
        this.m_businessQueryNameUI.getDocument().addDocumentListener(this);
        this.m_businessQueryNameUI.addActionListener(this);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_options));
        optionPanel.setLayout(new BoxLayout(optionPanel, 3));
        this.m_businessQueryCaseSensitiveUI = new JCheckBox(VWResource.s_caseSensitive);
        this.m_businessQueryCaseSensitiveUI.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_businessQueryCaseSensitiveUI.setSelected(this.m_bBusinessQueryCaseSensitive);
        this.m_businessQueryCaseSensitiveUI.addActionListener(this);
        this.m_businessQueryExactMatchUI = new JCheckBox(VWResource.s_exactMatch);
        this.m_businessQueryExactMatchUI.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_businessQueryExactMatchUI.setSelected(this.m_bBusinessQueryExactMatch);
        this.m_businessQueryExactMatchUI.addActionListener(this);
        optionPanel.add(this.m_businessQueryCaseSensitiveUI);
        optionPanel.add(this.m_businessQueryExactMatchUI);
        this.m_businessQueryExecuteBtn = new JButton(VWResource.s_execute);
        this.m_businessQueryExecuteBtn.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_businessQueryNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)optionPanel, c);
        c.gridy = 3;
        c.anchor = 10;
        c.fill = 0;
        panel.add((Component)this.m_businessQueryExecuteBtn, c);
        this.setButtonStatus(this.m_businessQueryNameUI, this.m_businessQueryExecuteBtn);
    }

    private void updateBusinessQueryPanel(BusinessQuery businessQuery) {
        this.initBusinessQueryPanel();
    }

    private void updateTModelQueryPanel(TModelQuery tModelQuery) {
        this.initTModelQueryPanel();
    }

    private void initBusinessDetailsPanel() {
        if (this.m_businessDetailsPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_businessDetailsPanel = new JPanel();
        this.m_businessDetailsPane = new JScrollPane(this.m_businessDetailsPanel);
        this.m_businessDetailsPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_businessDetails, 0);
        this.m_businessDetailsPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_bussinessNameUI = new JTextField();
        this.m_bussinessNameUI.setEditable(false);
        this.m_bussinessNameUI.setBorder(null);
        JLabel authorizedNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_authorizedName));
        this.m_bussinessAuthorizedNameUI = new JTextField();
        this.m_bussinessAuthorizedNameUI.setEditable(false);
        this.m_bussinessAuthorizedNameUI.setBorder(null);
        JLabel discoveryURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_discoveryURL));
        this.m_discoveryURLUI = new JTextArea();
        this.m_discoveryURLUI.setEditable(false);
        this.m_discoveryURLUI.setRows(2);
        this.m_discoveryURLUI.setColumns(20);
        this.m_discoveryURLUI.setLineWrap(true);
        this.m_discoveryURLUI.setWrapStyleWord(true);
        this.m_discoveryURLUI.setBackground(panel.getBackground());
        this.m_discoveryURLUseTypeUI = new JTextField();
        this.m_discoveryURLUseTypeUI.setEditable(false);
        this.m_discoveryURLUseTypeUI.setBorder(null);
        this.m_contactToolbarBorder = new ContactToolbarBorder(VWResource.s_contacts, 3);
        this.m_contactToolbarBorder.addToolbarBorderActionNotifier(this);
        this.m_contactToolbarBorder.setTooltip(1, VWResource.s_previousContact);
        this.m_contactToolbarBorder.setTooltip(2, VWResource.s_nextContact);
        JPanel contactPanel = this.m_contactToolbarBorder.getClientPanel();
        contactPanel.setBorder(BorderFactory.createEtchedBorder());
        contactPanel.setLayout(new GridBagLayout());
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_contactDescriptionUI = new JTextArea();
        this.m_contactDescriptionUI.setEditable(false);
        this.m_contactDescriptionUI.setRows(2);
        this.m_contactDescriptionUI.setColumns(20);
        this.m_contactDescriptionUI.setLineWrap(true);
        this.m_contactDescriptionUI.setWrapStyleWord(true);
        this.m_contactDescriptionUI.setBackground(panel.getBackground());
        JLabel contactUseTypeLabel = new JLabel(VWResource.s_label.toString(VWResource.s_contactUseType));
        this.m_contactUseTypeUI = new JTextField();
        this.m_contactUseTypeUI.setEditable(false);
        this.m_contactUseTypeUI.setBorder(null);
        JLabel contactNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_contactNameUI = new JTextField();
        this.m_contactNameUI.setEditable(false);
        this.m_contactNameUI.setBorder(null);
        this.m_contactAddressPanel = new JPanel();
        this.m_contactAddressPanel.setLayout(new BoxLayout(this.m_contactAddressPanel, 3));
        JLabel contactAddressLabel = new JLabel(VWResource.s_label.toString(VWResource.s_address));
        this.m_contactAddressPanel.add(contactAddressLabel);
        this.m_contactAddressUI = new JTextField[10];
        for (int i = 0; i < this.m_contactAddressUI.length; ++i) {
            this.m_contactAddressUI[i] = new JTextField();
            this.m_contactAddressUI[i].setEditable(false);
            this.m_contactAddressUI[i].setBorder(null);
            this.m_contactAddressPanel.add(this.m_contactAddressUI[i]);
            this.m_contactAddressUI[i].setVisible(false);
        }
        this.m_contactPhonePanel = new JPanel();
        this.m_contactPhonePanel.setLayout(new BoxLayout(this.m_contactPhonePanel, 3));
        JLabel contactPhoneLabel = new JLabel(VWResource.s_label.toString(VWResource.s_phoneNumbers));
        this.m_contactPhonePanel.add(contactPhoneLabel);
        this.m_contactPhoneUI = new JTextField[10];
        for (int i = 0; i < this.m_contactPhoneUI.length; ++i) {
            this.m_contactPhoneUI[i] = new JTextField();
            this.m_contactPhoneUI[i].setEditable(false);
            this.m_contactPhoneUI[i].setBorder(null);
            this.m_contactPhonePanel.add(this.m_contactPhoneUI[i]);
            this.m_contactPhoneUI[i].setVisible(false);
        }
        this.m_contactEmailPanel = new JPanel();
        this.m_contactEmailPanel.setLayout(new BoxLayout(this.m_contactEmailPanel, 3));
        JLabel contactEmailLabel = new JLabel(VWResource.s_label.toString(VWResource.s_emailAddresses));
        this.m_contactEmailPanel.add(contactEmailLabel);
        this.m_contactEmailUI = new JTextField[10];
        for (int i = 0; i < this.m_contactEmailUI.length; ++i) {
            this.m_contactEmailUI[i] = new JTextField();
            this.m_contactEmailUI[i].setEditable(false);
            this.m_contactEmailUI[i].setBorder(null);
            this.m_contactEmailPanel.add(this.m_contactEmailUI[i]);
            this.m_contactEmailUI[i].setVisible(false);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 23;
        c.insets = new Insets(0, 10, 0, 0);
        c.fill = 0;
        contactPanel.add((Component)contactNameLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        contactPanel.add((Component)this.m_contactNameUI, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(10, 10, 0, 0);
        contactPanel.add((Component)descriptionLabel, c);
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 10);
        contactPanel.add((Component)new JScrollPane(this.m_contactDescriptionUI), c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(10, 10, 0, 0);
        contactPanel.add((Component)contactUseTypeLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        contactPanel.add((Component)this.m_contactUseTypeUI, c);
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 0, 0);
        contactPanel.add((Component)this.m_contactAddressPanel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 0, 0);
        contactPanel.add((Component)this.m_contactPhonePanel, c);
        c.gridx = 0;
        c.gridy = 6;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 0, 0);
        contactPanel.add((Component)this.m_contactEmailPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_bussinessNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)authorizedNameLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_bussinessAuthorizedNameUI, c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)discoveryURLLabel, c);
        c.gridy = 5;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_discoveryURLUseTypeUI, c);
        c.gridy = 6;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_discoveryURLUI), c);
        c.gridy = 7;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.m_contactToolbarBorder, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateBusinessDetailsPanel(WSBusinessEntity businessEntity) {
        this.initBusinessDetailsPanel();
        if (this.m_businessDetailsPane == null) return;
        if (businessEntity == null) {
            return;
        }
        Cursor currentCursor = null;
        try {
            try {
                block16: {
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.m_bussinessNameUI != null) {
                        String name = null;
                        if (businessEntity.getName(0) != null) {
                            name = businessEntity.getName(0).getValue();
                        }
                        this.m_bussinessNameUI.setText(name);
                    }
                    if (this.m_bussinessAuthorizedNameUI != null) {
                        try {
                            this.m_bussinessAuthorizedNameUI.setText(businessEntity.getAuthorizedName());
                        }
                        catch (Exception ex) {
                            this.m_bussinessAuthorizedNameUI.setText(null);
                            this.showMessage(VWResource.s_failedToRetrieveBusinessDetails, VWResource.s_error, 1, ex);
                        }
                    }
                    if (this.m_discoveryURLUI != null) {
                        try {
                            Object obj;
                            Vector discoveryURLs = businessEntity.getDiscoveryURLs();
                            this.m_discoveryURLUI.setText(null);
                            if (discoveryURLs == null || discoveryURLs.size() <= 0 || (obj = discoveryURLs.get(0)) == null || !(obj instanceof DiscoveryURL)) break block16;
                            DiscoveryURL discoveryURL = (DiscoveryURL)obj;
                            this.m_discoveryURLUI.setText(discoveryURL.getValue());
                            String useType = discoveryURL.getUseType();
                            if (useType != null) {
                                this.m_discoveryURLUseTypeUI.setText(VWResource.s_discoveryURLUseType.toString(useType));
                            } else {
                                this.m_discoveryURLUseTypeUI.setText(VWResource.s_discoveryURLUseType.toString());
                            }
                        }
                        catch (Exception ex) {
                            this.m_discoveryURLUI.setText(null);
                            this.showMessage(VWResource.s_failedToRetrieveBusinessDetails, VWResource.s_error, 1, ex);
                        }
                    }
                }
                this.m_contacts = businessEntity.getContactVector();
                this.m_currentContact = 0;
                this.updateContact();
                this.updateContactButtons();
                this.m_businessDetailsPanel.updateUI();
                this.m_businessDetailsPane.updateUI();
            }
            catch (Exception exception) {
                Object var8_11 = null;
                if (currentCursor == null) return;
                this.setCursor(currentCursor);
                return;
            }
            Object var8_10 = null;
            if (currentCursor == null) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (currentCursor == null) throw throwable;
            this.setCursor(currentCursor);
            throw throwable;
        }
        this.setCursor(currentCursor);
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_contactToolbarBorder) {
            int id = event.getID();
            if (id == 1) {
                this.previousContact();
            }
            if (id == 2) {
                this.nextContact();
            }
        }
    }

    private void updateContactButtons() {
        if (this.m_contacts == null || this.m_contacts.size() <= 1) {
            this.m_contactToolbarBorder.setEnabled(1, false);
            this.m_contactToolbarBorder.setEnabled(2, false);
        } else {
            this.m_contactToolbarBorder.setEnabled(1, this.m_currentContact != 0);
            this.m_contactToolbarBorder.setEnabled(2, this.m_currentContact < this.m_contacts.size() - 1);
        }
    }

    private void previousContact() {
        if (this.m_contacts != null) {
            if (this.m_currentContact == 0) {
                return;
            }
            --this.m_currentContact;
            this.updateContact();
            this.updateContactButtons();
        }
    }

    private void nextContact() {
        if (this.m_contacts != null) {
            if (this.m_currentContact >= this.m_contacts.size() - 1) {
                return;
            }
            ++this.m_currentContact;
            this.updateContact();
            this.updateContactButtons();
        }
    }

    private void updateContact() {
        try {
            Object obj;
            Contact contact = null;
            String description = null;
            String useType = null;
            String personName = null;
            if (this.m_currentContact != -1 && this.m_contacts != null && this.m_currentContact < this.m_contacts.size() && this.m_contacts != null && this.m_contacts.size() > 0 && (obj = this.m_contacts.get(this.m_currentContact)) != null && obj instanceof Contact) {
                contact = (Contact)obj;
                description = null;
                Vector v = contact.getDescriptionVector();
                if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Description) {
                    description = ((Description)v.get(0)).getValue();
                }
                useType = contact.getUseType();
                personName = contact.getPersonNameValue();
            }
            if (this.m_contactDescriptionUI != null) {
                this.m_contactDescriptionUI.setText(description);
            }
            if (this.m_contactUseTypeUI != null) {
                this.m_contactUseTypeUI.setText(useType);
            }
            if (this.m_contactNameUI != null) {
                this.m_contactNameUI.setText(personName);
            }
            this.updateContactAddresses(contact);
            this.updateContactPhoneNumbers(contact);
            this.updateContactEmails(contact);
        }
        catch (Exception ex) {
            int i;
            this.m_contactDescriptionUI.setText(null);
            this.m_contactUseTypeUI.setText(null);
            this.m_contactNameUI.setText(null);
            for (i = 0; i < this.m_contactAddressUI.length; ++i) {
                this.m_contactAddressUI[i].setText(null);
                this.m_contactAddressUI[i].setVisible(false);
            }
            for (i = 0; i < this.m_contactPhoneUI.length; ++i) {
                this.m_contactPhoneUI[i].setText(null);
                this.m_contactPhoneUI[i].setVisible(false);
            }
            for (i = 0; i < this.m_contactEmailUI.length; ++i) {
                this.m_contactEmailUI[i].setText(null);
                this.m_contactEmailUI[i].setVisible(false);
            }
            this.showMessage(VWResource.s_failedToRetrieveBusinessDetails, VWResource.s_error, 1, ex);
        }
    }

    private void updateContactAddresses(Contact contact) {
        if (this.m_contactAddressUI != null) {
            if (contact == null) {
                for (int i = 0; i < this.m_contactAddressUI.length; ++i) {
                    this.m_contactAddressUI[i].setVisible(false);
                }
                return;
            }
            Object obj = null;
            Vector addresses = contact.getAddressVector();
            if (addresses != null && addresses.size() > 0) {
                obj = addresses.get(0);
                if (obj != null && obj instanceof Address) {
                    int i = 0;
                    Vector addressLineVector = ((Address)obj).getAddressLineVector();
                    boolean bFirstLine = true;
                    if (this.m_contactAddressUI.length < addressLineVector.size()) {
                        JTextField[] contactAddressUI = new JTextField[addressLineVector.size()];
                        for (i = 0; i < this.m_contactAddressUI.length; ++i) {
                            contactAddressUI[i] = this.m_contactAddressUI[i];
                        }
                        while (i < contactAddressUI.length) {
                            contactAddressUI[i] = new JTextField();
                            this.m_contactAddressPanel.add(contactAddressUI[i]);
                            contactAddressUI[i].setVisible(false);
                            ++i;
                        }
                        this.m_contactAddressUI = contactAddressUI;
                    }
                    for (i = 0; i < addressLineVector.size(); ++i) {
                        obj = addressLineVector.get(i);
                        if (obj == null || !(obj instanceof AddressLine)) continue;
                        this.m_contactAddressUI[i].setText(((AddressLine)obj).getLineValue());
                        this.m_contactAddressUI[i].setVisible(true);
                    }
                    while (i < this.m_contactAddressUI.length) {
                        this.m_contactAddressUI[i].setVisible(false);
                        ++i;
                    }
                }
            } else {
                for (int i = 0; i < this.m_contactAddressUI.length; ++i) {
                    this.m_contactAddressUI[i].setVisible(false);
                }
            }
        }
        this.m_contactAddressPanel.updateUI();
    }

    private void updateContactPhoneNumbers(Contact contact) {
        if (this.m_contactPhoneUI != null) {
            if (contact == null) {
                for (int i = 0; i < this.m_contactPhoneUI.length; ++i) {
                    this.m_contactPhoneUI[i].setVisible(false);
                }
                return;
            }
            Object obj = null;
            Vector phoneNumbers = contact.getPhoneVector();
            if (phoneNumbers != null && phoneNumbers.size() > 0) {
                int i = 0;
                if (this.m_contactPhoneUI.length < phoneNumbers.size()) {
                    JTextField[] contactPhoneUI = new JTextField[phoneNumbers.size()];
                    for (i = 0; i < contactPhoneUI.length; ++i) {
                        contactPhoneUI[i] = this.m_contactPhoneUI[i];
                    }
                    while (i < contactPhoneUI.length) {
                        contactPhoneUI[i] = new JTextField();
                        this.m_contactPhonePanel.add(contactPhoneUI[i]);
                        contactPhoneUI[i].setVisible(false);
                        ++i;
                    }
                    this.m_contactPhoneUI = contactPhoneUI;
                }
                for (i = 0; i < phoneNumbers.size(); ++i) {
                    obj = phoneNumbers.get(i);
                    if (obj == null || !(obj instanceof Phone)) continue;
                    this.m_contactPhoneUI[i].setText(((Phone)obj).getValue());
                    this.m_contactPhoneUI[i].setVisible(true);
                }
                while (i < this.m_contactPhoneUI.length) {
                    this.m_contactPhoneUI[i].setVisible(false);
                    ++i;
                }
            } else {
                for (int i = 0; i < this.m_contactPhoneUI.length; ++i) {
                    this.m_contactPhoneUI[i].setVisible(false);
                }
            }
        }
        this.m_contactPhonePanel.updateUI();
    }

    private void updateContactEmails(Contact contact) {
        if (this.m_contactEmailUI != null) {
            if (contact == null) {
                for (int i = 0; i < this.m_contactEmailUI.length; ++i) {
                    this.m_contactEmailUI[i].setVisible(false);
                }
                return;
            }
            Object obj = null;
            Vector emailNumbers = contact.getEmailVector();
            if (emailNumbers != null && emailNumbers.size() > 0) {
                int i = 0;
                if (this.m_contactEmailUI.length < emailNumbers.size()) {
                    JTextField[] contactEmailUI = new JTextField[emailNumbers.size()];
                    for (i = 0; i < contactEmailUI.length; ++i) {
                        contactEmailUI[i] = this.m_contactEmailUI[i];
                    }
                    while (i < contactEmailUI.length) {
                        contactEmailUI[i] = new JTextField();
                        this.m_contactEmailPanel.add(contactEmailUI[i]);
                        contactEmailUI[i].setVisible(false);
                        ++i;
                    }
                    this.m_contactEmailUI = contactEmailUI;
                }
                for (i = 0; i < emailNumbers.size(); ++i) {
                    obj = emailNumbers.get(i);
                    if (obj == null || !(obj instanceof Email)) continue;
                    this.m_contactEmailUI[i].setText(((Email)obj).getValue());
                    this.m_contactEmailUI[i].setVisible(true);
                }
                while (i < this.m_contactEmailUI.length) {
                    this.m_contactEmailUI[i].setVisible(false);
                    ++i;
                }
            } else {
                for (int i = 0; i < this.m_contactEmailUI.length; ++i) {
                    this.m_contactEmailUI[i].setVisible(false);
                }
            }
        }
        this.m_contactEmailPanel.updateUI();
    }

    private void initTModelQueryPanel() {
        if (this.m_tModelQueryPanel != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_tModelQueryPanel = new JPanel();
        this.m_tModelQueryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlTModelQuery, 0);
        this.m_tModelQueryPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_tModelQueryNameUI = new JTextField();
        this.m_tModelQueryNameUI.getDocument().addDocumentListener(this);
        this.m_tModelQueryNameUI.addActionListener(this);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_options));
        optionPanel.setLayout(new BoxLayout(optionPanel, 3));
        this.m_tModelQueryCaseSensitiveUI = new JCheckBox(VWResource.s_caseSensitive);
        this.m_tModelQueryCaseSensitiveUI.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_tModelQueryCaseSensitiveUI.setSelected(this.m_bTModelQueryCaseSensitive);
        this.m_tModelQueryCaseSensitiveUI.addActionListener(this);
        this.m_tModelQueryExactMatchUI = new JCheckBox(VWResource.s_exactMatch);
        this.m_tModelQueryExactMatchUI.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_tModelQueryExactMatchUI.setSelected(this.m_bTModelQueryExactMatch);
        this.m_tModelQueryExactMatchUI.addActionListener(this);
        optionPanel.add(this.m_tModelQueryCaseSensitiveUI);
        optionPanel.add(this.m_tModelQueryExactMatchUI);
        this.m_tModelQueryExecuteBtn = new JButton(VWResource.s_execute);
        this.m_tModelQueryExecuteBtn.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_tModelQueryNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)optionPanel, c);
        c.gridy = 3;
        c.anchor = 10;
        c.fill = 0;
        panel.add((Component)this.m_tModelQueryExecuteBtn, c);
        this.setButtonStatus(this.m_tModelQueryNameUI, this.m_tModelQueryExecuteBtn);
    }

    private void initTModelDetailsPanel() {
        if (this.m_tModelDetailsPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_tModelDetailsPanel = new JPanel();
        this.m_tModelDetailsPane = new JScrollPane(this.m_tModelDetailsPanel);
        this.m_tModelDetailsPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlTModelDetails, 0);
        this.m_tModelDetailsPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_tModelNameUI = new JTextField();
        this.m_tModelNameUI.setEditable(false);
        this.m_tModelNameUI.setBorder(null);
        JLabel authorizedNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_authorizedName));
        this.m_tModelAuthorizedName = new JTextField();
        this.m_tModelAuthorizedName.setEditable(false);
        this.m_tModelAuthorizedName.setBorder(null);
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_tModelDescriptionUI = new JTextArea();
        this.m_tModelDescriptionUI.setEditable(false);
        this.m_tModelDescriptionUI.setRows(3);
        this.m_tModelDescriptionUI.setColumns(20);
        this.m_tModelDescriptionUI.setLineWrap(true);
        this.m_tModelDescriptionUI.setWrapStyleWord(true);
        this.m_tModelDescriptionUI.setBackground(panel.getBackground());
        JLabel overviewDocDescriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_overviewDocumentDescription));
        this.m_tModelOverviewDocDescriptionUI = new JTextArea();
        this.m_tModelOverviewDocDescriptionUI.setEditable(false);
        this.m_tModelOverviewDocDescriptionUI.setRows(2);
        this.m_tModelOverviewDocDescriptionUI.setColumns(20);
        this.m_tModelOverviewDocDescriptionUI.setLineWrap(true);
        this.m_tModelOverviewDocDescriptionUI.setWrapStyleWord(true);
        this.m_tModelOverviewDocDescriptionUI.setBackground(panel.getBackground());
        JLabel overviewDocURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_overviewDocumentURL));
        this.m_tModelOverviewDocURLUI = new JTextArea();
        this.m_tModelOverviewDocURLUI.setEditable(false);
        this.m_tModelOverviewDocURLUI.setRows(2);
        this.m_tModelOverviewDocURLUI.setColumns(20);
        this.m_tModelOverviewDocURLUI.setLineWrap(true);
        this.m_tModelOverviewDocURLUI.setWrapStyleWord(true);
        this.m_tModelOverviewDocURLUI.setBackground(panel.getBackground());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_tModelNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)authorizedNameLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_tModelAuthorizedName, c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)descriptionLabel, c);
        c.gridy = 5;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_tModelDescriptionUI), c);
        c.gridy = 6;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)overviewDocDescriptionLabel, c);
        c.gridy = 7;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_tModelOverviewDocDescriptionUI), c);
        c.gridy = 8;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)overviewDocURLLabel, c);
        c.gridy = 9;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_tModelOverviewDocURLUI), c);
    }

    private void updateTModelDetailsPanel(WSTModel tModel) {
        this.initTModelDetailsPanel();
        if (this.m_tModelDetailsPane == null || tModel == null) {
            return;
        }
        if (this.m_tModelNameUI != null) {
            this.m_tModelNameUI.setText(tModel.getName());
        }
        if (this.m_tModelAuthorizedName != null) {
            this.m_tModelAuthorizedName.setText(tModel.getAuthorizedName());
        }
        if (this.m_tModelDescriptionUI != null) {
            this.m_tModelDescriptionUI.setText(tModel.getDescription());
        }
        if (this.m_tModelOverviewDocDescriptionUI != null) {
            this.m_tModelOverviewDocDescriptionUI.setText(tModel.getOverviewDocDescription());
        }
        if (this.m_tModelDescriptionUI != null) {
            this.m_tModelOverviewDocURLUI.setText(tModel.getOverviewDocURL());
        }
        this.m_tModelDetailsPane.updateUI();
    }

    public String getLastSelectedWSDLURL() {
        if (this.m_lastSelectedTModel != null) {
            return this.m_lastSelectedTModel.getOverviewDocURL();
        }
        return null;
    }

    public String getSelectedWSDLURL() {
        if (this.m_currentSelectedTModel != null) {
            return this.m_currentSelectedTModel.getOverviewDocURL();
        }
        return null;
    }

    private JScrollPane initTreePanel() {
        this.m_tree = new JTree(this.m_rootNode);
        this.m_tree.setCellRenderer(new TreeCellRenderer());
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addTreeWillExpandListener(this);
        this.m_tree.addMouseListener(this);
        TreeModel treeModel = this.m_tree.getModel();
        if (treeModel != null && treeModel instanceof DefaultTreeModel) {
            this.m_treeModel = (DefaultTreeModel)treeModel;
        }
        return new JScrollPane(this.m_tree);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_businessQueryNameUI) {
            this.m_businessQueryExecuteBtn.doClick();
        } else if (source == this.m_businessQueryExecuteBtn) {
            this.executeBusinessQuery();
        } else if (source == this.m_businessQueryCaseSensitiveUI) {
            this.m_bBusinessQueryCaseSensitive = this.m_businessQueryCaseSensitiveUI.isSelected();
        } else if (source == this.m_businessQueryExactMatchUI) {
            this.m_bBusinessQueryExactMatch = this.m_businessQueryExactMatchUI.isSelected();
        } else if (source == this.m_tModelQueryNameUI) {
            this.m_tModelQueryExecuteBtn.doClick();
        } else if (source == this.m_tModelQueryExecuteBtn) {
            this.executeTModelQuery();
        } else if (source == this.m_tModelQueryCaseSensitiveUI) {
            this.m_bTModelQueryCaseSensitive = this.m_tModelQueryCaseSensitiveUI.isSelected();
        } else if (source == this.m_tModelQueryExactMatchUI) {
            this.m_bTModelQueryExactMatch = this.m_tModelQueryExactMatchUI.isSelected();
        } else if (source == this.m_refreshMenuItem && this.m_popupTreeNode != null && this.m_popupTreeNode.isRoot()) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeBusinessQuery() {
        Cursor currentCursor;
        DefaultMutableTreeNode selectedTreeNode;
        block14: {
            block13: {
                selectedTreeNode = null;
                if (this.m_lastBusinessQueryObject == null) return;
                currentCursor = null;
                try {
                    try {
                        selectedTreeNode = this.getSelectedTreeNode();
                        if (selectedTreeNode == null) {
                            Object var7_3 = null;
                            if (this.m_treeModel != null && selectedTreeNode != null) {
                                this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                            }
                            if (currentCursor == null) return;
                            break block13;
                        }
                        currentCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        WSBusinessEntity[] businessEntities = this.m_lastBusinessQueryObject.findBusinessByName();
                        selectedTreeNode.removeAllChildren();
                        if (businessEntities != null && businessEntities.length > 0) {
                            for (int i = 0; i < businessEntities.length; ++i) {
                                if (businessEntities[i] == null) continue;
                                DefaultMutableTreeNode businessNode = new DefaultMutableTreeNode(businessEntities[i]);
                                selectedTreeNode.add(businessNode);
                                businessNode.add(new DefaultMutableTreeNode(new SearchBusinessTModel(businessNode)));
                            }
                        }
                        TreePath[] treePath = this.m_tree.getSelectionPaths();
                        this.m_tree.scrollPathToVisible(treePath[0]);
                        if (treePath == null || treePath[0] == null || treePath[0].getLastPathComponent() != this.m_tree.getLastSelectedPathComponent()) break block14;
                        this.m_tree.scrollPathToVisible(treePath[0]);
                        if (businessEntities != null && businessEntities.length > 0) {
                            this.m_tree.expandPath(treePath[0]);
                        }
                        break block14;
                    }
                    catch (Exception ex) {
                        this.showMessage(VWResource.s_failedToQueryForBusinesses, VWResource.s_error, 1, ex);
                        Object var7_5 = null;
                        if (this.m_treeModel != null && selectedTreeNode != null) {
                            this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                        }
                        if (currentCursor == null) return;
                        this.setCursor(currentCursor);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (this.m_treeModel != null && selectedTreeNode != null) {
                        this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                    }
                    if (currentCursor == null) throw throwable;
                    this.setCursor(currentCursor);
                    throw throwable;
                }
            }
            this.setCursor(currentCursor);
            return;
        }
        Object var7_4 = null;
        if (this.m_treeModel != null && selectedTreeNode != null) {
            this.m_treeModel.nodeStructureChanged(selectedTreeNode);
        }
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeTModelQuery() {
        Cursor currentCursor;
        block12: {
            block11: {
                if (this.m_lastTModelQueryObject == null) return;
                currentCursor = null;
                try {
                    try {
                        TreePath[] treePath;
                        currentCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        DefaultMutableTreeNode selectedTreeNode = this.getSelectedTreeNode();
                        if (selectedTreeNode == null) {
                            Object var7_4 = null;
                            if (currentCursor == null) return;
                            break block11;
                        }
                        WSTModel[] tModels = this.m_lastTModelQueryObject.findWSDLTModelByName();
                        selectedTreeNode.removeAllChildren();
                        if (tModels != null && tModels.length != 0) {
                            for (int i = 0; i < tModels.length; ++i) {
                                if (tModels[i] == null) continue;
                                DefaultMutableTreeNode tModelNode = new DefaultMutableTreeNode(tModels[i]);
                                selectedTreeNode.add(tModelNode);
                            }
                        }
                        if ((treePath = this.m_tree.getSelectionPaths()) != null && treePath[0] != null && treePath[0].getLastPathComponent() == this.m_tree.getLastSelectedPathComponent()) {
                            this.m_tree.scrollPathToVisible(treePath[0]);
                            if (tModels != null && tModels.length > 0) {
                                this.m_tree.expandPath(treePath[0]);
                            }
                        }
                        if (this.m_treeModel != null) {
                            this.m_treeModel.nodeStructureChanged(selectedTreeNode);
                        }
                        break block12;
                    }
                    catch (Exception ex) {
                        this.showMessage(VWResource.s_failedToQueryForTModels, VWResource.s_error, 1, ex);
                        Object var7_6 = null;
                        if (currentCursor == null) return;
                        this.setCursor(currentCursor);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (currentCursor == null) throw throwable;
                    this.setCursor(currentCursor);
                    throw throwable;
                }
            }
            this.setCursor(currentCursor);
            return;
        }
        Object var7_5 = null;
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.m_mainPanel != null) {
            int dividerLocation = this.m_mainPanel.getDividerLocation();
            super.setBounds(x, y, width, height);
            this.m_mainPanel.setDividerLocation(dividerLocation);
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    public void setBounds(Rectangle r) {
        if (this.m_mainPanel != null) {
            int dividerLocation = this.m_mainPanel.getDividerLocation();
            super.setBounds(r);
            this.m_mainPanel.setDividerLocation(dividerLocation);
        } else {
            super.setBounds(r);
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setButtonStatus(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.setButtonStatus(event);
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void setButtonStatus(DocumentEvent event) {
        Document doc = event.getDocument();
        JTextField textField = null;
        JButton button = null;
        if (this.m_tModelQueryNameUI != null && doc == this.m_tModelQueryNameUI.getDocument()) {
            textField = this.m_tModelQueryNameUI;
            button = this.m_tModelQueryExecuteBtn;
        } else if (this.m_businessQueryNameUI != null && doc == this.m_businessQueryNameUI.getDocument()) {
            textField = this.m_businessQueryNameUI;
            button = this.m_businessQueryExecuteBtn;
        } else {
            return;
        }
        this.setButtonStatus(textField, button);
    }

    private void setButtonStatus(JTextField textField, JButton button) {
        String tempString;
        boolean bEnable = false;
        if (textField != null && (tempString = textField.getText()) != null) {
            tempString.trim();
            if (tempString.length() > 0) {
                bEnable = true;
            }
        }
        if (button.isEnabled() != bEnable) {
            button.setEnabled(bEnable);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        return node;
    }

    public Object[] getSelectedObjects() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null) {
            Object[] objects = null;
            objects = new Object[]{nodeInfo};
            return objects;
        }
        return null;
    }

    protected void notifySelectListeners() {
        Object nodeInfo = this.getSelectedObject();
        String wsdlURL = null;
        if (nodeInfo != null && !(nodeInfo instanceof WSUDDIRegistry) && !(nodeInfo instanceof WSBusinessEntity) && nodeInfo instanceof WSTModel) {
            wsdlURL = ((WSTModel)nodeInfo).getOverviewDocURL();
        }
        ItemEvent event = new ItemEvent(this, 0, wsdlURL, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object nodeInfo = this.getSelectedObject();
        JComponent newComponent = null;
        if (nodeInfo != null) {
            this.m_currentSelectedTModel = null;
            if (nodeInfo instanceof UDDIRegistry[]) {
                newComponent = this.m_blankPanel;
            } else if (nodeInfo instanceof UDDIRegistry) {
                this.updateUDDIRegistryPanel((UDDIRegistry)nodeInfo);
                newComponent = this.m_uddiRegistryPane;
            } else if (nodeInfo instanceof WSBusinessEntity) {
                this.updateBusinessDetailsPanel((WSBusinessEntity)nodeInfo);
                this.getBusinessTModels(this.getSelectedTreeNode());
                newComponent = this.m_businessDetailsPane;
            } else if (nodeInfo instanceof TModelQuery) {
                this.updateTModelQueryPanel((TModelQuery)nodeInfo);
                this.m_lastTModelQueryObject = (TModelQuery)nodeInfo;
                newComponent = this.m_tModelQueryPanel;
            } else if (nodeInfo instanceof WSTModel) {
                this.updateTModelDetailsPanel((WSTModel)nodeInfo);
                newComponent = this.m_tModelDetailsPane;
                this.m_currentSelectedTModel = this.m_lastSelectedTModel = (WSTModel)nodeInfo;
            } else if (nodeInfo instanceof BusinessQuery) {
                this.updateBusinessQueryPanel((BusinessQuery)nodeInfo);
                this.m_lastBusinessQueryObject = (BusinessQuery)nodeInfo;
                newComponent = this.m_businessQueryPanel;
            }
            this.notifySelectListeners();
            if (newComponent != null) {
                int dividerLocation = this.m_mainPanel.getDividerLocation();
                if (this.compOrientation.isLeftToRight()) {
                    this.m_mainPanel.setRightComponent(newComponent);
                } else {
                    this.m_mainPanel.setLeftComponent(newComponent);
                }
                this.m_mainPanel.setDividerLocation(dividerLocation);
                this.m_mainPanel.updateUI();
            }
        }
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath treePath = event.getPath();
        Object obj = treePath.getLastPathComponent();
        if (obj != null && obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
            this.getBusinessTModels(treeNode);
        }
    }

    private void getBusinessTModels(DefaultMutableTreeNode treeNode) {
        TreeNode node;
        Object obj = null;
        obj = treeNode.getUserObject();
        if (obj != null && obj instanceof WSBusinessEntity && treeNode.getChildCount() == 1 && (node = treeNode.getChildAt(0)) != null && node instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)node).getUserObject()) != null && obj instanceof SearchBusinessTModel) {
            ((SearchBusinessTModel)obj).searchAddTModelToNode();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    private String showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private String showMessage(String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (this.m_parent instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)this.m_parent, msg, title, msgType);
        } else if (this.m_parent instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)this.m_parent, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(this.m_parent, msg, title, msgType);
        }
        return msg;
    }

    class ContactToolbarBorder
    extends VWToolbarBorder {
        public ContactToolbarBorder(String title, int flags) {
            super(title, flags);
        }

        void setEnabled(int ctrlId, boolean bEnabled) {
            int nEnable = bEnabled ? 1 : 2;
            this.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.getClientPanel(), nEnable, ctrlId));
        }
    }

    class SearchBusinessTModel {
        DefaultMutableTreeNode m_treeNode = null;

        public SearchBusinessTModel(DefaultMutableTreeNode treeNode) {
            this.m_treeNode = treeNode;
        }

        public void searchAddTModelToNode() {
            if (this.m_treeNode == null) {
                return;
            }
            this.m_treeNode.removeAllChildren();
            Object obj = this.m_treeNode.getUserObject();
            if (obj != null && obj instanceof WSBusinessEntity) {
                WSBusinessEntity businessEntity = (WSBusinessEntity)obj;
                try {
                    WSTModel[] tModels = businessEntity.getTModels();
                    if (tModels != null && tModels.length > 0) {
                        block2: for (int j = 0; j < tModels.length; ++j) {
                            Vector categories;
                            if (tModels[j] == null || (categories = tModels[j].getCategories()) == null) continue;
                            for (int i = 0; i < categories.size(); ++i) {
                                String keyvalue;
                                obj = categories.get(i);
                                if (obj == null || !(obj instanceof KeyedReference) || (keyvalue = ((KeyedReference)obj).getKeyValue()) == null || keyvalue.compareTo("wsdlSpec") != 0) continue;
                                this.m_treeNode.add(new DefaultMutableTreeNode(tModels[j]));
                                continue block2;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (VWUDDIExplorerPanel.this.m_treeModel != null) {
                VWUDDIExplorerPanel.this.m_treeModel.nodeStructureChanged(this.m_treeNode);
            }
        }
    }

    class UDDIRegistry {
        private String m_name = null;
        private URL m_inquiryURL = null;
        private URL m_publishURL = null;
        private boolean m_bPublish = false;
        private WSUDDIRegistry m_uddiRegistry = null;

        public UDDIRegistry(VWUDDIRegistry uddiRegistry) {
            this(uddiRegistry.getName(), uddiRegistry.getInquiryURL(), uddiRegistry.getPublishURL(), uddiRegistry.getPublish());
        }

        public UDDIRegistry(String name, String inquiryURL, String publishURL, boolean bPublish) {
            this.m_name = name;
            try {
                if (inquiryURL != null && inquiryURL.length() > 0) {
                    this.m_inquiryURL = new URL(inquiryURL);
                }
            }
            catch (Exception ex) {
                this.m_inquiryURL = null;
            }
            try {
                if (publishURL != null && publishURL.length() > 0) {
                    this.m_publishURL = new URL(publishURL);
                }
            }
            catch (Exception ex) {
                this.m_publishURL = null;
            }
            this.m_bPublish = bPublish;
        }

        public WSUDDIRegistry getUDDIRegistry() {
            return this.m_uddiRegistry;
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.getName();
        }

        public String getInquiryURL() {
            if (this.m_inquiryURL != null) {
                return this.m_inquiryURL.toString();
            }
            return null;
        }

        public String getPublishURL() {
            if (this.m_publishURL != null) {
                return this.m_publishURL.toString();
            }
            return null;
        }

        public WSBusinessEntity[] findBusinessByName(String name) throws Exception {
            if (this.m_uddiRegistry == null) {
                this.m_uddiRegistry = new WSUDDIRegistry(this.m_name, this.m_inquiryURL, this.m_publishURL, false);
            }
            if (this.m_uddiRegistry != null) {
                return this.m_uddiRegistry.findBusinessByName(name);
            }
            return null;
        }

        public WSBusinessEntity[] findBusinessByName(String name, boolean bCaseSensitive, boolean bExactMatch) throws Exception {
            if (this.m_uddiRegistry == null) {
                this.m_uddiRegistry = new WSUDDIRegistry(this.m_name, this.m_inquiryURL, this.m_publishURL, false);
            }
            if (this.m_uddiRegistry != null) {
                return this.m_uddiRegistry.findBusinessByName(name, bCaseSensitive, bExactMatch);
            }
            return null;
        }

        public WSTModel[] findTModelByName(String name, boolean bCaseSensitive, boolean bExactMatch) throws Exception {
            if (this.m_uddiRegistry == null) {
                this.m_uddiRegistry = new WSUDDIRegistry(this.m_name, this.m_inquiryURL, this.m_publishURL, false);
            }
            if (this.m_uddiRegistry != null) {
                return this.m_uddiRegistry.findTModel(name, bCaseSensitive, bExactMatch);
            }
            return null;
        }
    }

    class UDDIRegistryList {
        UDDIRegistryList() {
        }

        public UDDIRegistry[] getUDDIRegistryList() {
            return VWUDDIExplorerPanel.this.m_uddiRegistryList;
        }

        public String toString() {
            return VWResource.s_uddiBusinessRegistries;
        }
    }

    class TModelQuery {
        UDDIRegistry m_uddiRegistry = null;

        public TModelQuery(UDDIRegistry uddiRegistry) {
            this.m_uddiRegistry = uddiRegistry;
        }

        public UDDIRegistry getUDDIRegistry() {
            return this.m_uddiRegistry;
        }

        public String toString() {
            return VWResource.s_wsdlTModelList;
        }

        public WSTModel[] findWSDLTModelByName() throws Exception {
            if (VWUDDIExplorerPanel.this.m_tModelQueryNameUI != null) {
                WSTModel[] tModels;
                boolean bCaseSensitive = VWUDDIExplorerPanel.this.m_tModelQueryCaseSensitiveUI.isSelected();
                boolean bExactMatch = VWUDDIExplorerPanel.this.m_tModelQueryExactMatchUI.isSelected();
                String name = VWUDDIExplorerPanel.this.m_tModelQueryNameUI.getText();
                if (this.m_uddiRegistry != null && name != null && (tModels = this.m_uddiRegistry.findTModelByName(name, bCaseSensitive, bExactMatch)) != null && tModels.length > 0) {
                    Vector<WSTModel> tModelVector = new Vector<WSTModel>();
                    Object obj = null;
                    block0: for (int i = 0; i < tModels.length; ++i) {
                        Vector categories;
                        if (tModels[i] == null || (categories = tModels[i].getCategories()) == null || categories.size() <= 0) continue;
                        for (int j = 0; j < categories.size(); ++j) {
                            String keyvalue;
                            obj = categories.get(j);
                            if (obj == null || !(obj instanceof KeyedReference) || (keyvalue = ((KeyedReference)obj).getKeyValue()) == null || keyvalue.compareTo("wsdlSpec") != 0) continue;
                            tModelVector.add(tModels[i]);
                            continue block0;
                        }
                    }
                    if (tModelVector.size() > 0) {
                        WSTModel[] tModelArray = new WSTModel[tModelVector.size()];
                        tModelVector.toArray(tModelArray);
                        return tModelArray;
                    }
                }
            }
            return null;
        }
    }

    class BusinessQuery {
        UDDIRegistry m_uddiRegistry = null;

        public BusinessQuery(UDDIRegistry uddiRegistry) {
            this.m_uddiRegistry = uddiRegistry;
        }

        public UDDIRegistry getUDDIRegistry() {
            return this.m_uddiRegistry;
        }

        public String toString() {
            return new String(VWResource.s_businessList);
        }

        public WSBusinessEntity[] findBusinessByName() throws Exception {
            if (VWUDDIExplorerPanel.this.m_businessQueryNameUI != null) {
                boolean bCaseSensitive = VWUDDIExplorerPanel.this.m_businessQueryCaseSensitiveUI.isSelected();
                boolean bExactMatch = VWUDDIExplorerPanel.this.m_businessQueryExactMatchUI.isSelected();
                String name = VWUDDIExplorerPanel.this.m_businessQueryNameUI.getText();
                if (this.m_uddiRegistry != null && name != null) {
                    return this.m_uddiRegistry.findBusinessByName(name, bCaseSensitive, bExactMatch);
                }
            }
            return null;
        }
    }

    class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_uddiMainIcon = VWImageLoader.createImageIcon("uddiMain.gif");
        private ImageIcon m_uddiRegistryIcon = VWImageLoader.createImageIcon("uddiRegistry.gif");
        private ImageIcon m_businessListIcon = VWImageLoader.createImageIcon("uddiBusinessList.gif");
        private ImageIcon m_businessEntityIcon = VWImageLoader.createImageIcon("uddiBusinessDetails.gif");
        private ImageIcon m_tModelIcon = VWImageLoader.createImageIcon("uddiTModel.gif");
        private ImageIcon m_tModelListIcon = VWImageLoader.createImageIcon("uddiTModelList.gif");

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            comp.setComponentOrientation(tree.getComponentOrientation());
            if (value != null) {
                String text = null;
                Object nodeInfo = null;
                if (value instanceof DefaultMutableTreeNode) {
                    nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
                }
                if (nodeInfo != null) {
                    text = nodeInfo.toString();
                    if (nodeInfo instanceof UDDIRegistryList) {
                        this.setIcon(this.m_uddiMainIcon);
                    }
                    if (nodeInfo instanceof UDDIRegistry) {
                        this.setIcon(this.m_uddiRegistryIcon);
                    } else if (nodeInfo instanceof WSBusinessEntity) {
                        this.setIcon(this.m_businessEntityIcon);
                    } else if (nodeInfo instanceof WSTModel) {
                        this.setIcon(this.m_tModelIcon);
                    } else if (nodeInfo instanceof BusinessQuery) {
                        this.setIcon(this.m_businessListIcon);
                    } else if (nodeInfo instanceof TModelQuery) {
                        this.setIcon(this.m_tModelListIcon);
                    }
                    this.setText(text);
                    this.setToolTipText(text);
                }
                return this;
            }
            return comp;
        }
    }
}

